function []=config_write(aorw,adr,data)
%function []=config_write(aorw,adr,data)
% Write an entry to a cofig file for autostarting a microcontroller
% - if ConfigLog.c exists in the current directory then it appends a 'c' style line
% - if ConfigLog.bin exists in the current directory then it appends a binary entry
% this function is called in response to a udpset udp_bit_set or udp_bit_clear command_line_path
%
% aorw is a character to tell the routine what operation is to be performed
% - A - not and - or bit clear
% - O - or  - or bit set
% - W - write
% adr is the start address of the data to be 'written'
% data is the data to be written
%
% The .c file format is as follows - for later inclusion at app compile time
% *(uint32_t *)0x40021018|=0x4;
% *(uint32_t *)0x40010800&=~0xff;
% *(uint32_t *)0x40000428=0x0;
% integer type is the largest allowed by the data length to ensure register wide operations
%
% The .bin file format is as follows - for later downloading to the StartUp string
%  on the microcontrller using the udp_put_startup.m script
% format for config
%
% List_Type (255)
% Command(8 bit) addr(32bit) length(16bit) data(8bit).....
% Command(8 bit) addr(32bit) length(16bit) data(8bit).....
% Command(8 bit) addr(32bit) length(16bit) data(8bit).....
% .
% .
% Command(8 bit) addr(32bit) length(16bit) data(8bit).....
% end of list (0)
%
% Command
%  0 end of list
%  1 write
%  2 bit set
%  3 not and (bit clear)
%  255 List Type 1
% note data addr and length are lsb first - little endian
%
% see also udp_put_startup.m config_write.m udp_capture_start.m udp_capture_stop.m AutoConfExample.m
% V1.0 Ian Stothers 10 May 2023
fn=[];
if (exist('ConfigLogType.c')==2) fn='ConfigLog.c'; end
if (exist('ConfigLogType.bin')==2) fn='ConfigLog.bin'; end

if(min(size(fn))>0)
 adr=double(adr);
 fh=fopen(fn,'a+');
% .c write stuff
 if (fn(end)=='c')
  sd=max(size(data));
  dat=double(data);
  dat=dat*(256.^(0:(sd-1))');

  if (aorw=='A') K='&=~';if (dat==0) return; endif endif
  if (aorw=='O') K='|='; if (dat==0) return; endif  endif
  if (aorw=='W') K='='; end
  if (sd==4)
   fprintf(fh,['*(uint32_t *)0x%x' K '0x%x'],adr,dat);
  end
  if (sd==2)
   fprintf(fh,['*(uint16_t *)0x%x' K '0x%x'],adr,dat);
  end
  if (sd==1)
     fprintf(fh,['*(uint8_t *)0x%x' K '0x%x'],adr,dat);
  end
  fprintf(fh,';\n');

 else

  % .bin write stuff
  if (aorw=='A') k=3; endif
  if (aorw=='O') k=2; endif
  if (aorw=='W') k=1'; endif

  data=data(:);
  sd=max(size(data));
  len=[256*((sd/256)-floor(sd/256)) floor(sd/256)];

  addr=[0 0 0 0];
  for x=1:4
   addr(x)=256*((adr/256)-floor(adr/256));
   adr=floor(adr/256);
  endfor
  if ((k==1)||((k>1)&&(sum(data)>0)))
   fwrite(fh,[k addr len data'],'uint8');
  endif
 endif
 fclose(fh);
endif
